<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseProspect is autogenerate by UniModel generator
 *
 * This is the model class for table "prospect".
 *
 * The followings are the available columns in table 'prospect':
 * @property string $prospect_id
 * @property integer $advisor_ref_id
 * @property string $user_ref_id
 * @property integer $prospect_category_ref_id
 * @property integer $short_list_advisor_ref_id
 * @property string $prospect_status
 * @property string $status_reason
 * @property string $assigned_date
 * @property integer $reassigned_from
 * @property string $reassigned_date
 * @property string $decision_date
 * @property string $date_time_to_call
 * @property string $added_on
 * @property integer $added_by
 * @property string $modified_on
 * @property integer $modified_by
 * @property integer $prospect_main_status_ref_id
 * @property integer $prospect_sub_status_ref_id
 * @property string $lead_type
 * @property string $test_source
 * @property string $vendor_source
 * @property string $gem_source
 * @property string $umail_exist
 * @property integer $test_page_visit
 * @property string $vendor_page_visit
 *
 * The followings are the available model relations:
 * @property TblAdmin $shortListAdvisorRef
 * @property TblAdmin $addedBy
 * @property TblAdmin $advisorRef
 * @property EntranceExam $testPageVisit
 * @property LookupProspectStatus $prospectMainStatusRef
 * @property TblAdmin $modifiedBy
 * @property LookupProspectCategory $prospectCategoryRef
 * @property TblAdmin $reassignedFrom
 * @property LookupProspectStatus $prospectSubStatusRef
 * @property TblUserMaster $userRef
 * @property VendorCentre $vendorPageVisit
 * @property ProspectInteraction[] $prospectInteractions
 */
class BaseProspect extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return Prospect the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'prospect';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('user_ref_id, reassigned_date', 'required'),
			array('advisor_ref_id, prospect_category_ref_id, short_list_advisor_ref_id, reassigned_from, added_by, modified_by, prospect_main_status_ref_id, prospect_sub_status_ref_id, test_page_visit', 'numerical', 'integerOnly'=>true),
			array('user_ref_id, lead_type, test_source, vendor_page_visit', 'length', 'max'=>10),
			array('prospect_status, vendor_source', 'length', 'max'=>15),
			array('status_reason', 'length', 'max'=>255),
			array('gem_source', 'length', 'max'=>20),
			array('umail_exist', 'length', 'max'=>1),
			array('assigned_date, decision_date, date_time_to_call, added_on, modified_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('prospect_id, advisor_ref_id, user_ref_id, prospect_category_ref_id, short_list_advisor_ref_id, prospect_status, status_reason, assigned_date, reassigned_from, reassigned_date, decision_date, date_time_to_call, added_on, added_by, modified_on, modified_by, prospect_main_status_ref_id, prospect_sub_status_ref_id, lead_type, test_source, vendor_source, gem_source, umail_exist, test_page_visit, vendor_page_visit', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'shortListAdvisorRef' => array(self::BELONGS_TO, 'TblAdmin', 'short_list_advisor_ref_id'),
			'addedBy' => array(self::BELONGS_TO, 'TblAdmin', 'added_by'),
			'advisorRef' => array(self::BELONGS_TO, 'TblAdmin', 'advisor_ref_id'),
			'testPageVisit' => array(self::BELONGS_TO, 'EntranceExam', 'test_page_visit'),
			'prospectMainStatusRef' => array(self::BELONGS_TO, 'LookupProspectStatus', 'prospect_main_status_ref_id'),
			'modifiedBy' => array(self::BELONGS_TO, 'TblAdmin', 'modified_by'),
			'prospectCategoryRef' => array(self::BELONGS_TO, 'LookupProspectCategory', 'prospect_category_ref_id'),
			'reassignedFrom' => array(self::BELONGS_TO, 'TblAdmin', 'reassigned_from'),
			'prospectSubStatusRef' => array(self::BELONGS_TO, 'LookupProspectStatus', 'prospect_sub_status_ref_id'),
			'userRef' => array(self::BELONGS_TO, 'TblUserMaster', 'user_ref_id'),
			'vendorPageVisit' => array(self::BELONGS_TO, 'VendorCentre', 'vendor_page_visit'),
			'prospectInteractions' => array(self::HAS_MANY, 'ProspectInteraction', 'prospect_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'prospect_id' => 'Prospect',
			'advisor_ref_id' => 'Advisor Ref',
			'user_ref_id' => 'User Ref',
			'prospect_category_ref_id' => 'Prospect Category Ref',
			'short_list_advisor_ref_id' => 'Short List Advisor Ref',
			'prospect_status' => 'Prospect Status',
			'status_reason' => 'Status Reason',
			'assigned_date' => 'Assigned Date',
			'reassigned_from' => 'Reassigned From',
			'reassigned_date' => 'Reassigned Date',
			'decision_date' => 'Decision Date',
			'date_time_to_call' => 'Date Time To Call',
			'added_on' => 'Added On',
			'added_by' => 'Added By',
			'modified_on' => 'Modified On',
			'modified_by' => 'Modified By',
			'prospect_main_status_ref_id' => 'Prospect Main Status Ref',
			'prospect_sub_status_ref_id' => 'Prospect Sub Status Ref',
			'lead_type' => 'Lead Type',
			'test_source' => 'Test Source',
			'vendor_source' => 'Vendor Source',
			'gem_source' => 'Gem Source',
			'umail_exist' => 'Umail Exist',
			'test_page_visit' => 'Test Page Visit',
			'vendor_page_visit' => 'Vendor Page Visit',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('prospect_id',$this->prospect_id,true);
		$criteria->compare('advisor_ref_id',$this->advisor_ref_id);
		$criteria->compare('user_ref_id',$this->user_ref_id,true);
		$criteria->compare('prospect_category_ref_id',$this->prospect_category_ref_id);
		$criteria->compare('short_list_advisor_ref_id',$this->short_list_advisor_ref_id);
		$criteria->compare('prospect_status',$this->prospect_status,true);
		$criteria->compare('status_reason',$this->status_reason,true);
		$criteria->compare('assigned_date',$this->assigned_date,true);
		$criteria->compare('reassigned_from',$this->reassigned_from);
		$criteria->compare('reassigned_date',$this->reassigned_date,true);
		$criteria->compare('decision_date',$this->decision_date,true);
		$criteria->compare('date_time_to_call',$this->date_time_to_call,true);
		$criteria->compare('added_on',$this->added_on,true);
		$criteria->compare('added_by',$this->added_by);
		$criteria->compare('modified_on',$this->modified_on,true);
		$criteria->compare('modified_by',$this->modified_by);
		$criteria->compare('prospect_main_status_ref_id',$this->prospect_main_status_ref_id);
		$criteria->compare('prospect_sub_status_ref_id',$this->prospect_sub_status_ref_id);
		$criteria->compare('lead_type',$this->lead_type,true);
		$criteria->compare('test_source',$this->test_source,true);
		$criteria->compare('vendor_source',$this->vendor_source,true);
		$criteria->compare('gem_source',$this->gem_source,true);
		$criteria->compare('umail_exist',$this->umail_exist,true);
		$criteria->compare('test_page_visit',$this->test_page_visit);
		$criteria->compare('vendor_page_visit',$this->vendor_page_visit,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}